/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.builder.client.GuiChamberDetails;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketChamberInfoReady {
    private Map<BlockState, Integer> blocks;
    private Map<BlockState, Integer> costs;
    private Map<BlockState, ItemStack> stacks;
    private Map<String, Integer> entities;
    private Map<String, Integer> entityCosts;
    private Map<String, Entity> realEntities;
    private Map<String, String> playerNames;
    private static final byte ENTITY_NONE = 0;
    private static final byte ENTITY_NORMAL = 1;
    private static final byte ENTITY_PLAYER = 2;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockState, Integer> entry : this.blocks.entrySet()) {
            BlockState bm = entry.getKey();
            buf.writeInt(Block.m_49956_((BlockState)bm));
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(bm).intValue());
            if (this.stacks.containsKey(bm)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)this.stacks.get(bm));
                continue;
            }
            buf.writeBoolean(false);
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            String name = (String)entry.getKey();
            buf.m_130070_(name);
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(name).intValue());
            if (this.realEntities.containsKey(name)) {
                Entity entity = this.realEntities.get(name);
                if (entity instanceof Player) {
                    buf.writeByte(2);
                    int entityId = entity.m_142049_();
                    buf.writeInt(entityId);
                    buf.m_130070_(entity.m_5446_().getString());
                    continue;
                }
                buf.writeByte(1);
                CompoundTag nbt = entity.serializeNBT();
                PacketChamberInfoReady.writeNBT(buf, nbt);
                continue;
            }
            buf.writeByte(0);
        }
    }

    private static CompoundTag readNBT(FriendlyByteBuf buf) {
        return buf.m_130260_();
    }

    private static void writeNBT(FriendlyByteBuf dataOut, CompoundTag nbt) {
        FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)dataOut);
        try {
            buf.m_130079_(nbt);
        }
        catch (Exception e) {
            Logging.logError((String)"Error writing packet chamber info", (Throwable)e);
        }
    }

    public PacketChamberInfoReady() {
    }

    public PacketChamberInfoReady(FriendlyByteBuf buf) {
        int cost;
        int count;
        int i;
        int size = buf.readInt();
        this.blocks = new HashMap<BlockState, Integer>(size);
        this.costs = new HashMap<BlockState, Integer>(size);
        this.stacks = new HashMap<BlockState, ItemStack>();
        for (i = 0; i < size; ++i) {
            BlockState bm = Block.m_49803_((int)buf.readInt());
            count = buf.readInt();
            cost = buf.readInt();
            this.blocks.put(bm, count);
            this.costs.put(bm, cost);
            if (!buf.readBoolean()) continue;
            ItemStack stack = NetworkTools.readItemStack((FriendlyByteBuf)buf);
            this.stacks.put(bm, stack);
        }
        size = buf.readInt();
        this.entities = new HashMap<String, Integer>(size);
        this.entityCosts = new HashMap<String, Integer>(size);
        this.realEntities = new HashMap<String, Entity>();
        this.playerNames = new HashMap<String, String>();
        for (i = 0; i < size; ++i) {
            String className = buf.m_130136_(Short.MAX_VALUE);
            count = buf.readInt();
            cost = buf.readInt();
            this.entities.put(className, count);
            this.entityCosts.put(className, cost);
            byte how = buf.readByte();
            if (how == 1) {
                CompoundTag compoundTag = PacketChamberInfoReady.readNBT(buf);
                continue;
            }
            if (how != 2) continue;
            int entityId = buf.readInt();
            String entityName = buf.m_130136_(Short.MAX_VALUE);
            Entity entity = SafeClientTools.getClientWorld().m_6815_(entityId);
            if (entity != null) {
                this.realEntities.put(className, entity);
            }
            this.playerNames.put(className, entityName);
        }
    }

    public PacketChamberInfoReady(Map<BlockState, Integer> blocks, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities) {
        this.blocks = new HashMap<BlockState, Integer>(blocks);
        this.costs = new HashMap<BlockState, Integer>(costs);
        this.stacks = new HashMap<BlockState, ItemStack>(stacks);
        this.entities = new HashMap<String, Integer>(entities);
        this.entityCosts = new HashMap<String, Integer>(entityCosts);
        this.realEntities = new HashMap<String, Entity>(realEntities);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiChamberDetails.setItemsWithCount(this.blocks, this.costs, this.stacks, this.entities, this.entityCosts, this.realEntities, this.playerNames));
        ctx.setPacketHandled(true);
    }
}

